/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.ConstrBuilder;
import copt.ConstrBuilderArray;
import copt.CoptException;
import copt.CoptJniWrapper;
import copt.Expr;
import copt.ICallback;
import copt.ICallbackProxy;
import copt.SWIGTYPE_p_double;
import copt.Var;
import copt.VarArray;
import copt.coptjniwrap;

public abstract class CallbackBase
extends ICallback {
    private ICallbackProxy _proxy = CoptJniWrapper.CreateCallbackProxy();

    @Override
    public abstract void callback();

    public void dispose() {
        this.finalize();
    }

    @Override
    protected void finalize() {
        this._proxy.finalize();
    }

    public void interrupt() throws CoptException {
        this._proxy.Interrupt();
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addUserCut(Expr expr, char c, double d) throws CoptException {
        this._proxy.AddUserCut(expr.get(), c, d);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addUserCut(Expr expr, char c, Expr expr2) throws CoptException {
        this._proxy.AddUserCut(expr.get(), c, expr2.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addUserCut(ConstrBuilder constrBuilder) throws CoptException {
        this._proxy.AddUserCut(constrBuilder.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addUserCuts(ConstrBuilderArray constrBuilderArray) throws CoptException {
        this._proxy.AddUserCuts(constrBuilderArray.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addLazyConstr(Expr expr, char c, double d) throws CoptException {
        this._proxy.AddLazyConstr(expr.get(), c, d);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addLazyConstr(Expr expr, char c, Expr expr2) throws CoptException {
        this._proxy.AddLazyConstr(expr.get(), c, expr2.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addLazyConstr(ConstrBuilder constrBuilder) throws CoptException {
        this._proxy.AddLazyConstr(constrBuilder.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void addLazyConstrs(ConstrBuilderArray constrBuilderArray) throws CoptException {
        this._proxy.AddLazyConstrs(constrBuilderArray.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public int getIntInfo(String string) throws CoptException {
        int n = this._proxy.GetIntInfo(string);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return n;
    }

    public double getDblInfo(String string) throws CoptException {
        double d = this._proxy.GetDblInfo(string);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return d;
    }

    public double getIncumbent(Var var) throws CoptException {
        double d = this._proxy.GetIncumbent(var.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return d;
    }

    public double[] getIncumbent(VarArray varArray) throws CoptException {
        int n = varArray.size();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        int n2 = this._proxy.GetIncumbent(varArray.get(), sWIGTYPE_p_double);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = CoptJniWrapper.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public double[] getIncumbent(Var[] varArray) throws CoptException {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        return this.getIncumbent(varArray2);
    }

    public double[] getIncumbent() throws CoptException {
        int n = this._proxy.GetIncumbent(null, 0);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        SWIGTYPE_p_double sWIGTYPE_p_double = coptjniwrap.new_dblArray(n);
        this._proxy.GetIncumbent(sWIGTYPE_p_double, n);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = coptjniwrap.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        coptjniwrap.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public double getRelaxSol(Var var) throws CoptException {
        double d = this._proxy.GetRelaxSol(var.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return d;
    }

    public double[] getRelaxSol(VarArray varArray) throws CoptException {
        int n = varArray.size();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        int n2 = this._proxy.GetRelaxSol(varArray.get(), sWIGTYPE_p_double);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = CoptJniWrapper.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public double[] getRelaxSol(Var[] varArray) throws CoptException {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        return this.getRelaxSol(varArray2);
    }

    public double[] getRelaxSol() throws CoptException {
        int n = this._proxy.GetRelaxSol(null, 0);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        SWIGTYPE_p_double sWIGTYPE_p_double = coptjniwrap.new_dblArray(n);
        this._proxy.GetRelaxSol(sWIGTYPE_p_double, n);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = coptjniwrap.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        coptjniwrap.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public double getSolution(Var var) throws CoptException {
        double d = this._proxy.GetSolution(var.get());
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return d;
    }

    public double[] getSolution(VarArray varArray) throws CoptException {
        int n = varArray.size();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        int n2 = this._proxy.GetSolution(varArray.get(), sWIGTYPE_p_double);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = CoptJniWrapper.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public double[] getSolution(Var[] varArray) throws CoptException {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        return this.getSolution(varArray2);
    }

    public double[] getSolution() throws CoptException {
        int n = this._proxy.GetSolution(null, 0);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        SWIGTYPE_p_double sWIGTYPE_p_double = coptjniwrap.new_dblArray(n);
        this._proxy.GetSolution(sWIGTYPE_p_double, n);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = coptjniwrap.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        coptjniwrap.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public void setSolution(Var var, double d) throws CoptException {
        this._proxy.SetSolution(var.get(), d);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void setSolution(VarArray varArray, double[] dArray) throws CoptException {
        int n = varArray.size();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._proxy.SetSolution(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
    }

    public void setSolution(Var[] varArray, double[] dArray) throws CoptException {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        this.setSolution(varArray2, dArray);
    }

    public double loadSolution() throws CoptException {
        double d = this._proxy.LoadSolution();
        CoptException.checkError(this._proxy.GetLastError(), this._proxy.GetErrorMessage());
        return d;
    }

    public int where() {
        return this._proxy.Where();
    }

    @Override
    public ICallbackProxy getProxy() {
        return this._proxy;
    }
}

