/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.ConstrArray;
import copt.Constraint;
import copt.CoptJniWrapper;
import copt.IColumn;
import copt.IConstraint;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.coptjniwrapJNI;
import java.util.Arrays;

public class Column {
    private IColumn _self;

    public Column() {
        this._self = CoptJniWrapper.CreateColumn();
    }

    public Column(IColumn iColumn) {
        this._self = iColumn;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public int size() {
        return this._self.Size();
    }

    public Constraint getConstr(int n) {
        long l = coptjniwrapJNI.IColumn_GetConstr(IColumn.getCPtr(this._self), this._self, n);
        IConstraint iConstraint = l == 0L ? null : new IConstraint(l, true);
        return new Constraint(iConstraint);
    }

    public double getCoeff(int n) {
        return this._self.GetCoeff(n);
    }

    public void addTerm(Constraint constraint, double d) {
        this._self.AddTerm(constraint.get(), d);
    }

    public void addTerms(Constraint[] constraintArray, double d) {
        int n = constraintArray.length;
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(constraintArray, dArray);
    }

    public void addTerms(Constraint[] constraintArray, double[] dArray) {
        ConstrArray constrArray = new ConstrArray();
        for (Constraint constraint : constraintArray) {
            constrArray.pushBack(constraint);
        }
        this.addTerms(constrArray, dArray);
    }

    public void addTerms(ConstrArray constrArray, double d) {
        int n = constrArray.size();
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(constrArray, dArray);
    }

    public void addTerms(ConstrArray constrArray, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(constrArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public void addColumn(Column column) {
        this.addColumn(column, 1.0);
    }

    public void addColumn(Column column, double d) {
        this._self.AddColumn(column.get(), d);
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(Constraint constraint) {
        this._self.Remove(constraint.get());
    }

    public void clear() {
        this._self.Clear();
    }

    public Column clone() {
        long l = coptjniwrapJNI.IColumn_Clone(IColumn.getCPtr(this._self), this._self);
        IColumn iColumn = l == 0L ? null : new IColumn(l, true);
        return new Column(iColumn);
    }

    public IColumn get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            String string;
            if (this.getConstr(i).getIdx() < 0 || this.getCoeff(i) == 0.0) continue;
            String string2 = string = this.getCoeff(i) > 0.0 ? " + " : " - ";
            if (stringBuilder.length() > 0 || this.getCoeff(i) < 0.0) {
                stringBuilder.append(string);
            }
            if (Math.abs(this.getCoeff(i)) != 1.0) {
                stringBuilder.append(Math.abs(this.getCoeff(i)) + " * ");
            }
            stringBuilder.append(this.getConstr(i).getName());
        }
        return stringBuilder.toString();
    }
}

