/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptJniWrapper;
import copt.Expr;
import copt.IConstrBuilder;
import copt.SwigManager;

public class ConstrBuilder {
    private IConstrBuilder _self;

    public ConstrBuilder() {
        this._self = CoptJniWrapper.CreateConstrBuilder();
    }

    public ConstrBuilder(IConstrBuilder iConstrBuilder) {
        this._self = iConstrBuilder;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public Expr getExpr() {
        return new Expr(this._self.GetExpr());
    }

    public char getSense() {
        return this._self.GetSense();
    }

    public double getRange() {
        return this._self.GetRange();
    }

    public void set(Expr expr, char c, double d) {
        this._self.Set(expr.get(), c, d);
    }

    public void setRange(Expr expr, double d) {
        this._self.SetRange(expr.get(), d);
    }

    public IConstrBuilder get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.getSense();
        if (c == 'R') {
            stringBuilder.append(-this.getRange() + " <= ");
            stringBuilder.append(this.getExpr() + " <= 0.0");
            return stringBuilder.toString();
        }
        switch (c) {
            case 'L': {
                stringBuilder.append(this.getExpr() + " <= 0.0");
                break;
            }
            case 'G': {
                stringBuilder.append(this.getExpr() + " >= 0.0");
                break;
            }
            case 'E': {
                stringBuilder.append(this.getExpr() + " == 0.0");
                break;
            }
            case 'N': {
                stringBuilder.append(this.getExpr() + " FREE");
                break;
            }
            default: {
                stringBuilder.append(" UNKNOWN");
            }
        }
        return stringBuilder.toString();
    }
}

