/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.IExpr;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.Var;
import copt.VarArray;
import java.util.Arrays;

public class Expr {
    private IExpr _self;

    public Expr() {
        this._self = CoptJniWrapper.CreateExpr(0.0);
    }

    public Expr(double d) {
        this._self = CoptJniWrapper.CreateExpr(d);
    }

    public Expr(Var var) {
        this._self = CoptJniWrapper.CreateLinExpr(var.get(), 1.0);
    }

    public Expr(Var var, double d) {
        this._self = CoptJniWrapper.CreateLinExpr(var.get(), d);
    }

    public Expr(IExpr iExpr) {
        this._self = iExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public long size() {
        return this._self.Size();
    }

    public Var getVar(int n) {
        return new Var(this._self.GetVar(n));
    }

    public double getCoeff(int n) {
        return this._self.GetCoeff(n);
    }

    public double getConstant() {
        return this._self.GetConstant();
    }

    public void setCoeff(int n, double d) {
        this._self.SetCoeff(n, d);
    }

    public void addConstant(double d) {
        this._self.AddConstant(d);
    }

    public void setConstant(double d) {
        this._self.SetConstant(d);
    }

    public void addTerm(Var var, double d) {
        this._self.AddTerm(var.get(), d);
    }

    public void addTerms(Var[] varArray, double d) {
        int n = varArray.length;
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(varArray, dArray);
    }

    public void addTerms(Var[] varArray, double[] dArray) {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        this.addTerms(varArray2, dArray);
    }

    public void addTerms(VarArray varArray, double d) {
        int n = varArray.size();
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(varArray, dArray);
    }

    public void addTerms(VarArray varArray, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public void addExpr(Expr expr) {
        this.addExpr(expr, 1.0);
    }

    public void addExpr(Expr expr, double d) {
        this._self.AddExpr(expr.get(), d);
    }

    public double evaluate() throws CoptException {
        double d = this._self.Evaluate();
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return d;
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(Var var) {
        this._self.Remove(var.get());
    }

    public Expr clone() {
        return new Expr(this._self.Clone());
    }

    public Expr add(Expr expr, double d) {
        this._self.AddExpr(expr.get(), d);
        return this;
    }

    public Expr add(Var var, double d) {
        this._self.AddTerm(var.get(), d);
        return this;
    }

    public Expr add(Expr expr) {
        this._self.AddExpr(expr.get(), 1.0);
        return this;
    }

    public Expr add(Var var) {
        this._self.AddTerm(var.get(), 1.0);
        return this;
    }

    public Expr add(double d) {
        this._self.AddConstant(d);
        return this;
    }

    public Expr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public Expr divide(double d) {
        this._self.iDivide(d);
        return this;
    }

    public String represent(long l) {
        return this._self.Represent(l);
    }

    public IExpr get() {
        return this._self;
    }

    public String toString() {
        return this.represent(512L);
    }
}

