/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptJniWrapper;
import copt.Expr;
import copt.IGenConstrBuilder;
import copt.SwigManager;
import copt.Var;

public class GenConstrBuilder {
    private IGenConstrBuilder _self;

    public GenConstrBuilder() {
        this._self = CoptJniWrapper.CreateGenConstrBuilder();
    }

    public GenConstrBuilder(IGenConstrBuilder iGenConstrBuilder) {
        this._self = iGenConstrBuilder;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public Var getBinVar() {
        return new Var(this._self.GetBinVar());
    }

    public int getBinVal() {
        return this._self.GetBinVal();
    }

    public Expr getExpr() {
        return new Expr(this._self.GetExpr());
    }

    public char getSense() {
        return this._self.GetSense();
    }

    public int getIndType() {
        return this._self.GetIndType();
    }

    public void set(Var var, int n, Expr expr, char c) {
        this._self.Set(var.get(), n, expr.get(), c, 1);
    }

    public void set(Var var, int n, Expr expr, char c, int n2) {
        this._self.Set(var.get(), n, expr.get(), c, n2);
    }

    public IGenConstrBuilder get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(" + this.getBinVar().getName());
        stringBuilder.append(" == " + this.getBinVal() + ")");
        int n = this.getIndType();
        switch (n) {
            case 1: {
                stringBuilder.append(" -> ");
                break;
            }
            case 2: {
                stringBuilder.append(" <- ");
                break;
            }
            case 3: {
                stringBuilder.append(" <-> ");
                break;
            }
            default: {
                stringBuilder.append(" INVALID TYPE ");
            }
        }
        char c = this.getSense();
        switch (c) {
            case 'L': {
                stringBuilder.append("(" + this.getExpr() + " <= 0.0)");
                break;
            }
            case 'G': {
                stringBuilder.append("(" + this.getExpr() + " >= 0.0)");
                break;
            }
            case 'E': {
                stringBuilder.append("(" + this.getExpr() + " == 0.0)");
                break;
            }
            default: {
                stringBuilder.append(" UNKNOWN");
            }
        }
        return stringBuilder.toString();
    }
}

