/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.ILmiConstraint;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.SymMatrix;

public class LmiConstraint {
    private ILmiConstraint _self;

    public LmiConstraint(ILmiConstraint iLmiConstraint) {
        this._self = iLmiConstraint;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public int getIdx() {
        return this._self.GetIdx();
    }

    public int getDim() {
        return this._self.GetDim();
    }

    public int getLen() {
        return this._self.GetLen();
    }

    public String getName() {
        return this._self.GetName();
    }

    public double[] get(String string) throws CoptException {
        int n = this.getDim() * this.getDim();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        this._self.Get(string, sWIGTYPE_p_double, n);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = CoptJniWrapper.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return dArray;
    }

    public void setRhs(SymMatrix symMatrix) {
        this._self.SetRhs(symMatrix.get());
    }

    public void remove() {
        this._self.Remove();
    }

    public ILmiConstraint get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LMIRow(" + this.getName());
        if (this.getIdx() < 0) {
            stringBuilder.append(" Removed");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

