/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptJniWrapper;
import copt.ILmiExpr;
import copt.SwigManager;
import copt.SymMatExpr;
import copt.SymMatrix;
import copt.SymMatrixArray;
import copt.Var;
import copt.VarArray;

public class LmiExpr {
    private ILmiExpr _self;

    public LmiExpr() {
        this._self = CoptJniWrapper.CreateLmiExpr1();
    }

    public LmiExpr(SymMatrix symMatrix) {
        this._self = CoptJniWrapper.CreateLmiExpr2(symMatrix.get());
    }

    public LmiExpr(SymMatExpr symMatExpr) {
        this._self = CoptJniWrapper.CreateLmiExpr3(symMatExpr.get());
    }

    public LmiExpr(Var var, SymMatrix symMatrix) {
        this._self = CoptJniWrapper.CreateLmiExpr4(var.get(), symMatrix.get());
    }

    public LmiExpr(Var var, SymMatExpr symMatExpr) {
        this._self = CoptJniWrapper.CreateLmiExpr5(var.get(), symMatExpr.get());
    }

    public LmiExpr(ILmiExpr iLmiExpr) {
        this._self = iLmiExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public long size() {
        return this._self.Size();
    }

    public Var getVar(int n) {
        return new Var(this._self.GetVar(n));
    }

    public SymMatExpr getCoeff(int n) {
        return new SymMatExpr(this._self.GetCoeff(n));
    }

    public SymMatExpr getConstant() {
        return new SymMatExpr(this._self.GetConstant());
    }

    public void setCoeff(int n, SymMatrix symMatrix) {
        this._self.SetCoeff(n, symMatrix.get());
    }

    public void setConstant(SymMatrix symMatrix) {
        this._self.SetConstant(symMatrix.get());
    }

    public void addConstant(SymMatExpr symMatExpr) {
        this._self.AddConstant(symMatExpr.get());
    }

    public void addTerm(Var var, SymMatrix symMatrix) {
        this._self.AddTerm(var.get(), symMatrix.get());
    }

    public void addTerm(Var var, SymMatExpr symMatExpr) {
        this._self.AddTerm(var.get(), symMatExpr.get());
    }

    public void addTerms(VarArray varArray, SymMatrixArray symMatrixArray) {
        this._self.AddTerms(varArray.get(), symMatrixArray.get());
    }

    public void addTerms(Var[] varArray, SymMatrix[] symMatrixArray) {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        SymMatrixArray symMatrixArray2 = new SymMatrixArray();
        for (SymMatrix symMatrix : symMatrixArray) {
            symMatrixArray2.pushBack(symMatrix);
        }
        this.addTerms(varArray2, symMatrixArray2);
    }

    public void addLmiExpr(LmiExpr lmiExpr) {
        this._self.AddLmiExpr(lmiExpr.get(), 1.0);
    }

    public void addLmiExpr(LmiExpr lmiExpr, double d) {
        this._self.AddLmiExpr(lmiExpr.get(), d);
    }

    public LmiExpr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(Var var) {
        this._self.Remove(var.get());
    }

    public LmiExpr clone() {
        return new LmiExpr(this._self.Clone());
    }

    public ILmiExpr get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getConstant());
        int n = 0;
        while ((long)n < this.size()) {
            if (this.getVar(n).getIdx() >= 0) {
                stringBuilder.append(" + (");
                stringBuilder.append(this.getCoeff(n) + ")");
                stringBuilder.append(" * ");
                stringBuilder.append(this.getVar(n).getName());
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

