/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.Expr;
import copt.INlExpr;
import copt.QuadExpr;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.Var;
import copt.VarArray;

public class NlExpr {
    private INlExpr _self;

    public NlExpr() {
        this._self = CoptJniWrapper.CreateNlExpr1(0.0);
    }

    public NlExpr(double d) {
        this._self = CoptJniWrapper.CreateNlExpr1(d);
    }

    public NlExpr(Var var) {
        this._self = CoptJniWrapper.CreateNlExpr2(var.get(), 1.0);
    }

    public NlExpr(Var var, double d) {
        this._self = CoptJniWrapper.CreateNlExpr2(var.get(), d);
    }

    public NlExpr(Expr expr) {
        this._self = CoptJniWrapper.CreateNlExpr3(expr.get());
    }

    public NlExpr(QuadExpr quadExpr) {
        this._self = CoptJniWrapper.CreateNlExpr4(quadExpr.get());
    }

    public NlExpr(INlExpr iNlExpr) {
        this._self = iNlExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public long size() {
        return this._self.Size();
    }

    public double getConstant() {
        return this._self.GetConstant();
    }

    public void addConstant(double d) {
        this._self.AddConstant(d);
    }

    public void setConstant(double d) {
        this._self.SetConstant(d);
    }

    public void addTerm(Var var, double d) {
        this._self.AddTerm(var.get(), d);
    }

    public void addTerms(Var[] varArray, double[] dArray) {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        this.addTerms(varArray2, dArray);
    }

    public void addTerms(VarArray varArray, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public Expr getLinExpr() {
        return new Expr(this._self.GetLinExpr());
    }

    public void addLinExpr(Expr expr, double d) {
        this._self.AddLinExpr(expr.get(), d);
    }

    public void addQuadExpr(QuadExpr quadExpr, double d) {
        this._self.AddQuadExpr(quadExpr.get(), d);
    }

    public void addNlExpr(NlExpr nlExpr, double d) {
        this._self.AddNlExpr(nlExpr.get(), d);
    }

    public void clear() {
        this._self.Clear();
    }

    public NlExpr clone() {
        return new NlExpr(this._self.Clone());
    }

    public double evaluate() throws CoptException {
        double d = this._self.Evaluate();
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return d;
    }

    public void reserve(int n) {
        this._self.Reserve(n);
    }

    public NlExpr add(NlExpr nlExpr, double d) {
        this._self.AddNlExpr(nlExpr.get(), d);
        return this;
    }

    public NlExpr add(QuadExpr quadExpr, double d) {
        this._self.AddQuadExpr(quadExpr.get(), d);
        return this;
    }

    public NlExpr add(Expr expr, double d) {
        this._self.AddLinExpr(expr.get(), d);
        return this;
    }

    public NlExpr add(Var var, double d) {
        this._self.AddTerm(var.get(), d);
        return this;
    }

    public NlExpr add(NlExpr nlExpr) {
        this._self.AddNlExpr(nlExpr.get(), 1.0);
        return this;
    }

    public NlExpr add(QuadExpr quadExpr) {
        this._self.AddQuadExpr(quadExpr.get(), 1.0);
        return this;
    }

    public NlExpr add(Expr expr) {
        this._self.AddLinExpr(expr.get(), 1.0);
        return this;
    }

    public NlExpr add(Var var) {
        this._self.AddTerm(var.get(), 1.0);
        return this;
    }

    public NlExpr add(double d) {
        this._self.AddConstant(d);
        return this;
    }

    public NlExpr divide(NlExpr nlExpr) throws CoptException {
        this._self.iDivide(nlExpr.get());
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return this;
    }

    public NlExpr divide(QuadExpr quadExpr) throws CoptException {
        this._self.iDivide(quadExpr.get());
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return this;
    }

    public NlExpr divide(Expr expr) throws CoptException {
        this._self.iDivide(expr.get());
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return this;
    }

    public NlExpr divide(Var var) throws CoptException {
        this._self.iDivide(var.get());
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return this;
    }

    public NlExpr divide(double d) throws CoptException {
        this._self.iDivide(d);
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return this;
    }

    public NlExpr multiply(NlExpr nlExpr) {
        this._self.iMultiply(nlExpr.get());
        return this;
    }

    public NlExpr multiply(QuadExpr quadExpr) {
        this._self.iMultiply(quadExpr.get());
        return this;
    }

    public NlExpr multiply(Expr expr) {
        this._self.iMultiply(expr.get());
        return this;
    }

    public NlExpr multiply(Var var) {
        this._self.iMultiply(var.get());
        return this;
    }

    public NlExpr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public NlExpr negate() {
        this._self.Negate();
        return this;
    }

    public String represent(long l) {
        return this._self.Represent(l);
    }

    public INlExpr get() {
        return this._self;
    }

    public String toString() {
        return this.represent(512L);
    }
}

