/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.Expr;
import copt.IPsdExpr;
import copt.PsdVar;
import copt.PsdVarArray;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.SymMatExpr;
import copt.SymMatrix;
import copt.SymMatrixArray;
import copt.Var;
import copt.VarArray;

public class PsdExpr {
    private IPsdExpr _self;

    public PsdExpr(double d) {
        this._self = CoptJniWrapper.CreatePsdExpr1(d);
    }

    public PsdExpr(Var var) {
        this._self = CoptJniWrapper.CreatePsdExpr2(var.get(), 1.0);
    }

    public PsdExpr(Var var, double d) {
        this._self = CoptJniWrapper.CreatePsdExpr2(var.get(), d);
    }

    public PsdExpr(Expr expr) {
        this._self = CoptJniWrapper.CreatePsdExpr3(expr.get());
    }

    public PsdExpr(PsdVar psdVar, SymMatrix symMatrix) {
        this._self = CoptJniWrapper.CreatePsdExpr4(psdVar.get(), symMatrix.get());
    }

    public PsdExpr(PsdVar psdVar, SymMatExpr symMatExpr) {
        this._self = CoptJniWrapper.CreatePsdExpr5(psdVar.get(), symMatExpr.get());
    }

    public PsdExpr(IPsdExpr iPsdExpr) {
        this._self = iPsdExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public long size() {
        return this._self.Size();
    }

    public PsdVar getPsdVar(int n) {
        return new PsdVar(this._self.GetPsdVar(n));
    }

    public SymMatExpr getCoeff(int n) {
        return new SymMatExpr(this._self.GetCoeff(n));
    }

    public double getConstant() {
        return this._self.GetConstant();
    }

    public Expr getLinExpr() {
        return new Expr(this._self.GetLinExpr());
    }

    public void setCoeff(int n, SymMatrix symMatrix) {
        this._self.SetCoeff(n, symMatrix.get());
    }

    public void setConstant(double d) {
        this._self.SetConstant(d);
    }

    public void addConstant(double d) {
        this._self.AddConstant(d);
    }

    public void addTerm(Var var, double d) {
        this._self.AddTerm(var.get(), d);
    }

    public void addTerm(PsdVar psdVar, SymMatrix symMatrix) {
        this._self.AddTerm(psdVar.get(), symMatrix.get());
    }

    public void addTerm(PsdVar psdVar, SymMatExpr symMatExpr) {
        this._self.AddTerm(psdVar.get(), symMatExpr.get());
    }

    public void addTerms(Var[] varArray, double d) {
        int n = varArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        this.addTerms(varArray, dArray);
    }

    public void addTerms(Var[] varArray, double[] dArray) {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        this.addTerms(varArray2, dArray);
    }

    public void addTerms(VarArray varArray, double d) {
        int n = varArray.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        this.addTerms(varArray, dArray);
    }

    public void addTerms(VarArray varArray, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public void addTerms(PsdVarArray psdVarArray, SymMatrixArray symMatrixArray) {
        this._self.AddTerms(psdVarArray.get(), symMatrixArray.get());
    }

    public void addTerms(PsdVar[] psdVarArray, SymMatrix[] symMatrixArray) {
        PsdVarArray psdVarArray2 = new PsdVarArray();
        for (PsdVar psdVar : psdVarArray) {
            psdVarArray2.pushBack(psdVar);
        }
        SymMatrixArray symMatrixArray2 = new SymMatrixArray();
        for (SymMatrix symMatrix : symMatrixArray) {
            symMatrixArray2.pushBack(symMatrix);
        }
        this.addTerms(psdVarArray2, symMatrixArray2);
    }

    public void addLinExpr(Expr expr) {
        this.addLinExpr(expr, 1.0);
    }

    public void addLinExpr(Expr expr, double d) {
        this._self.AddLinExpr(expr.get(), d);
    }

    public void addPsdExpr(PsdExpr psdExpr) {
        this._self.AddPsdExpr(psdExpr.get(), 1.0);
    }

    public void addPsdExpr(PsdExpr psdExpr, double d) {
        this._self.AddPsdExpr(psdExpr.get(), d);
    }

    public PsdExpr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public double evaluate() throws CoptException {
        double d = this._self.Evaluate();
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return d;
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(Var var) {
        this._self.Remove(var.get());
    }

    public void remove(PsdVar psdVar) {
        this._self.Remove(psdVar.get());
    }

    public PsdExpr clone() {
        return new PsdExpr(this._self.Clone());
    }

    public IPsdExpr get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLinExpr());
        int n = 0;
        while ((long)n < this.size()) {
            if (this.getPsdVar(n).getIdx() >= 0) {
                stringBuilder.append(" + (");
                stringBuilder.append(this.getCoeff(n) + ")");
                stringBuilder.append(" * ");
                stringBuilder.append(this.getPsdVar(n).getName());
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

