/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.Expr;
import copt.IQuadExpr;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.Var;
import copt.VarArray;
import java.util.Arrays;

public class QuadExpr {
    private IQuadExpr _self;

    public QuadExpr() {
        this._self = CoptJniWrapper.CreateQuadExpr1(0.0);
    }

    public QuadExpr(double d) {
        this._self = CoptJniWrapper.CreateQuadExpr1(d);
    }

    public QuadExpr(Var var) {
        this._self = CoptJniWrapper.CreateQuadExpr2(var.get(), 1.0);
    }

    public QuadExpr(Var var, double d) {
        this._self = CoptJniWrapper.CreateQuadExpr2(var.get(), d);
    }

    public QuadExpr(Expr expr) {
        this._self = CoptJniWrapper.CreateQuadExpr3(expr.get());
    }

    public QuadExpr(Var var, Var var2) {
        Expr expr = new Expr(var);
        this._self = CoptJniWrapper.CreateQuadExpr4(expr.get(), var2.get());
    }

    public QuadExpr(Expr expr, Var var) {
        this._self = CoptJniWrapper.CreateQuadExpr4(expr.get(), var.get());
    }

    public QuadExpr(Expr expr, Expr expr2) {
        this._self = CoptJniWrapper.CreateQuadExpr5(expr.get(), expr2.get());
    }

    public QuadExpr(IQuadExpr iQuadExpr) {
        this._self = iQuadExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public long size() {
        return this._self.Size();
    }

    public Var getVar1(int n) {
        return new Var(this._self.GetVar1(n));
    }

    public Var getVar2(int n) {
        return new Var(this._self.GetVar2(n));
    }

    public double getCoeff(int n) {
        return this._self.GetCoeff(n);
    }

    public double getConstant() {
        return this._self.GetConstant();
    }

    public Expr getLinExpr() {
        return new Expr(this._self.GetLinExpr());
    }

    public void setCoeff(int n, double d) {
        this._self.SetCoeff(n, d);
    }

    public void setConstant(double d) {
        this._self.SetConstant(d);
    }

    public void addConstant(double d) {
        this._self.AddConstant(d);
    }

    public void addTerm(Var var, double d) {
        this._self.AddTerm(var.get(), d);
    }

    public void addTerm(Var var, Var var2, double d) {
        this._self.AddTerm(var.get(), var2.get(), d);
    }

    public void addTerms(Var[] varArray, double d) {
        int n = varArray.length;
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(varArray, dArray);
    }

    public void addTerms(Var[] varArray, double[] dArray) {
        VarArray varArray2 = new VarArray();
        for (Var var : varArray) {
            varArray2.pushBack(var);
        }
        this.addTerms(varArray2, dArray);
    }

    public void addTerms(VarArray varArray, double d) {
        int n = varArray.size();
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        this.addTerms(varArray, dArray);
    }

    public void addTerms(VarArray varArray, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public void addTerms(VarArray varArray, VarArray varArray2, double[] dArray) {
        int n = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        for (int i = 0; i < n; ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.AddTerms(varArray.get(), varArray2.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public void addTerms(Var[] varArray, Var[] varArray2, double[] dArray) {
        VarArray varArray3 = new VarArray();
        for (Var var : varArray) {
            varArray3.pushBack(var);
        }
        VarArray varArray4 = new VarArray();
        for (Var var : varArray2) {
            varArray4.pushBack(var);
        }
        this.addTerms(varArray3, varArray4, dArray);
    }

    public void addLinExpr(Expr expr) {
        this.addLinExpr(expr, 1.0);
    }

    public void addLinExpr(Expr expr, double d) {
        this._self.AddLinExpr(expr.get(), d);
    }

    public void addQuadExpr(QuadExpr quadExpr) {
        this.addQuadExpr(quadExpr, 1.0);
    }

    public void addQuadExpr(QuadExpr quadExpr, double d) {
        this._self.AddQuadExpr(quadExpr.get(), d);
    }

    public double evaluate() throws CoptException {
        double d = this._self.Evaluate();
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return d;
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(Var var) {
        this._self.Remove(var.get());
    }

    public QuadExpr clone() {
        return new QuadExpr(this._self.Clone());
    }

    public QuadExpr add(QuadExpr quadExpr, double d) {
        this._self.AddQuadExpr(quadExpr.get(), d);
        return this;
    }

    public QuadExpr add(Expr expr, double d) {
        this._self.AddLinExpr(expr.get(), d);
        return this;
    }

    public QuadExpr add(Var var, double d) {
        this._self.AddTerm(var.get(), d);
        return this;
    }

    public QuadExpr add(QuadExpr quadExpr) {
        this._self.AddQuadExpr(quadExpr.get(), 1.0);
        return this;
    }

    public QuadExpr add(Expr expr) {
        this._self.AddLinExpr(expr.get(), 1.0);
        return this;
    }

    public QuadExpr add(Var var) {
        this._self.AddTerm(var.get(), 1.0);
        return this;
    }

    public QuadExpr add(double d) {
        this._self.AddConstant(d);
        return this;
    }

    public QuadExpr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public QuadExpr divide(double d) {
        this._self.iDivide(d);
        return this;
    }

    public String represent(long l) {
        return this._self.Represent(l);
    }

    public IQuadExpr get() {
        return this._self;
    }

    public String toString() {
        return this.represent(512L);
    }
}

