/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptJniWrapper;
import copt.ISosBuilder;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.Var;
import copt.VarArray;

public class SosBuilder {
    private ISosBuilder _self;

    public SosBuilder() {
        this._self = CoptJniWrapper.CreateSosBuilder();
    }

    public SosBuilder(ISosBuilder iSosBuilder) {
        this._self = iSosBuilder;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public int getType() {
        return this._self.GetType();
    }

    public int getSize() {
        return this._self.GetSize();
    }

    public Var getVar(int n) {
        return new Var(this._self.GetVar(n));
    }

    public VarArray GetVars() {
        return new VarArray(this._self.GetVars());
    }

    public double getWeight(int n) {
        return this._self.GetWeight(n);
    }

    public double[] getWeights() {
        int n = this.getSize();
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n);
        this._self.GetWeights(sWIGTYPE_p_double);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = CoptJniWrapper.dblArray_getitem(sWIGTYPE_p_double, i);
        }
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        return dArray;
    }

    public void set(VarArray varArray, double[] dArray, int n) {
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(varArray.size());
        for (int i = 0; i < varArray.size(); ++i) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, i, dArray[i]);
        }
        this._self.Set(varArray.get(), sWIGTYPE_p_double, n);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
    }

    public ISosBuilder get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getSize(); ++i) {
            String string;
            if (this.getVar(i).getIdx() < 0 || this.getWeight(i) == 0.0) continue;
            String string2 = string = this.getWeight(i) > 0.0 ? " + " : " - ";
            if (stringBuilder.length() > 0 || this.getWeight(i) < 0.0) {
                stringBuilder.append(string);
            }
            if (Math.abs(this.getWeight(i)) != 1.0) {
                stringBuilder.append(Math.abs(this.getWeight(i)) + " * ");
            }
            stringBuilder.append(this.getVar(i).getName());
        }
        stringBuilder.append("   <SOS Type " + this.getType() + ">");
        return stringBuilder.toString();
    }
}

