/*
 * Decompiled with CFR 0.152.
 */
package copt;

import copt.CoptException;
import copt.CoptJniWrapper;
import copt.ISymMatExpr;
import copt.SWIGTYPE_p_double;
import copt.SwigManager;
import copt.SymMatrix;
import copt.SymMatrixArray;

public class SymMatExpr {
    private ISymMatExpr _self;

    public SymMatExpr() {
        this._self = CoptJniWrapper.CreateSymMatExpr1();
    }

    public SymMatExpr(SymMatrix symMatrix, double d) {
        this._self = CoptJniWrapper.CreateSymMatExpr2(symMatrix.get(), d);
    }

    public SymMatExpr(ISymMatExpr iSymMatExpr) {
        this._self = iSymMatExpr;
        SwigManager.setOwnership(this._self, true);
    }

    public void dispose() {
        this.finalize();
    }

    protected void finalize() {
        this._self.finalize();
    }

    public int getDim() {
        return this._self.GetDim();
    }

    public long size() {
        return this._self.Size();
    }

    public SymMatrix getSymMat(int n) {
        return new SymMatrix(this._self.GetSymMat(n));
    }

    public double getCoeff(int n) {
        return this._self.GetCoeff(n);
    }

    public void setCoeff(int n, double d) {
        this._self.SetCoeff(n, d);
    }

    public Boolean addTerm(SymMatrix symMatrix, double d) throws CoptException {
        Boolean bl = this._self.AddTerm(symMatrix.get(), d);
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return bl;
    }

    public int addTerms(SymMatrixArray symMatrixArray, double[] dArray) throws CoptException {
        int n;
        int n2 = dArray.length;
        SWIGTYPE_p_double sWIGTYPE_p_double = CoptJniWrapper.new_dblArray(n2);
        for (n = 0; n < n2; ++n) {
            CoptJniWrapper.dblArray_setitem(sWIGTYPE_p_double, n, dArray[n]);
        }
        n = this._self.AddTerms(symMatrixArray.get(), sWIGTYPE_p_double, n2);
        CoptJniWrapper.delete_dblArray(sWIGTYPE_p_double);
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
        return n;
    }

    public int addTerms(SymMatrix[] symMatrixArray, double[] dArray) throws CoptException {
        SymMatrixArray symMatrixArray2 = new SymMatrixArray();
        for (SymMatrix symMatrix : symMatrixArray) {
            symMatrixArray2.pushBack(symMatrix);
        }
        return this.addTerms(symMatrixArray2, dArray);
    }

    public int addTerms(SymMatrix[] symMatrixArray, double d) throws CoptException {
        int n = symMatrixArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return this.addTerms(symMatrixArray, dArray);
    }

    public void addSymMatExpr(SymMatExpr symMatExpr, double d) throws CoptException {
        this._self.AddSymMatExpr(symMatExpr.get(), d);
        CoptException.checkError(this._self.GetLastError(), this._self.GetErrorMessage());
    }

    public SymMatExpr multiply(double d) {
        this._self.iMultiply(d);
        return this;
    }

    public void remove(int n) {
        this._self.Remove(n);
    }

    public void remove(SymMatrix symMatrix) {
        this._self.Remove(symMatrix.get());
    }

    public SymMatExpr clone() {
        return new SymMatExpr(this._self.Clone());
    }

    public void reserve(int n) {
        this._self.Reserve(n);
    }

    public ISymMatExpr get() {
        return this._self;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while ((long)n < this.size()) {
            if (n > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(this.getSymMat(n).toString());
            if (this.getCoeff(n) != 1.0) {
                stringBuilder.append(" * ");
                stringBuilder.append(this.getCoeff(n));
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

