﻿'
' This file is part of the Cardinal Optimizer, all rights reserved.
'
Imports Copt

' The problem to solve:
'
'  Maximize:
'    1.2 x + 1.8 y + 2.1 z
'
'  Subject to:
'    1.5 x + 1.2 y + 1.8 z <= 2.6
'    0.8 x + 0.6 y + 0.9 z >= 1.2
'
'  where:
'    0.1 <= x <= 0.6
'    0.2 <= y <= 1.5
'    0.3 <= z <= 2.8
Class Lp_ex1
  Shared Sub Main()
    Try
      ' Create COPT environment and model
      Dim env As New Envr()
      Dim model As Model = env.CreateModel("lp_ex1")

      ' Add variables
      '
      '   obj: 1.2 x + 1.8 y + 2.1 z
      '
      '   var:
      '     0.1 <= x <= 0.6
      '     0.2 <= y <= 1.5
      '     0.3 <= z <= 2.8
      '
      Dim x As Var = model.AddVar(0.1, 0.6, 0.0, Copt.Consts.CONTINUOUS, "x")
      Dim y As Var = model.AddVar(0.2, 1.5, 0.0, Copt.Consts.CONTINUOUS, "y")
      Dim z As Var = model.AddVar(0.3, 2.8, 0.0, Copt.Consts.CONTINUOUS, "z")

      model.SetObjective(1.2 * x + 1.8 * y + 2.1 * z, Copt.Consts.MAXIMIZE)

      ' Add new constraints using linear expression
      '
      '   r0: 1.5 x + 1.2 y + 1.8 z <= 2.6
      '   r1: 0.8 x + 0.6 y + 0.9 z >= 1.2
      '
      model.AddConstr(1.5 * x + 1.2 * y + 1.8 * z <= 2.6, "r0")

      Dim expr As Expr = New Expr(x, 0.8)
      expr.AddTerm(y, 0.6)
      expr.AddTerm(z, 0.9)
      model.AddConstr(expr >= 1.2, "r1")

      ' Set parameters and attributes
      model.SetDblParam(Copt.DblParam.TimeLimit, 10)

      ' Solve problem
      model.Solve()

      ' Output solution
      If model.GetIntAttr(Copt.IntAttr.LpStatus) = COPT.Status.OPTIMAL Then
        Console.WriteLine(vbLf & "Found optimal solution:")
        Dim vars As VarArray = model.GetVars()

        For i As Integer = 0 To vars.Size() - 1
          Dim var As Var = vars.GetVar(i)
          Console.WriteLine("  " & var.GetName() & " = " & var.Get(Copt.DblInfo.Value))
        Next

        Console.WriteLine("Obj = " & model.GetDblAttr(Copt.DblAttr.LpObjVal))
      End If

      Console.WriteLine(vbLf & "Done")
    Catch e As CoptException
      Console.WriteLine("Error Code = " & e.GetCode())
    End Try
  End Sub
End Class
